import pystim_pkg::*;

module handle_exception();
    typedef pystim_pkg::pystim py;

    initial begin
        py::initialize_interpreter();
        begin
            automatic py_dict globals = py::globals();
            automatic py_dict locals = py_dict::create_empty();
            automatic py_object status;

            status = py::exec("raise ValueError('Something went wrong')", globals, locals);
            if(status.is_error()) begin
                $display("An exception occurred: %s", status.to_string());
            end
        end
        py::finalize_interpreter();
    end

endmodule