import pystim_pkg::*;

module simple_calc();

  typedef pystim_pkg::pystim py;
 
  initial begin
    py::initialize_interpreter();
    begin
      //Python equivalent: from calc import Calculator
      automatic py_object Calculator = py_module::import_("calc").attr("Calculator");
      // equivalent: calc = Calculator(3)
      automatic py_object calc = Calculator.call(py::int_(3));
      // equivalent: res = calc.add(2)
      automatic py_object res = calc.attr("add").call(py::int_(2));
      // equivalent: res = calc.multiply(5)
      res = calc.attr("multiply").call(py::int_(5));

      assert (res.cast_int().get_value() == 25);
      $display("Result: (3 + 2) * 5 = %0s", res.to_string());
            
    end
    py::finalize_interpreter();
  end

endmodule