import pystim_pkg::*;

module pass_array();
    typedef pystim_pkg::pystim py;

    initial begin
        py::initialize_interpreter();
        begin
            automatic py_tuple tuple = py::tuple_({py::int_(1), py::int_(2), py::int_(3)});
            automatic py_dict globals = py::globals();
            automatic py_dict locals = py_dict::create_empty();
            globals.set(py::str_("data"), tuple);
            py::exec("print('Data received in Python:', data)", globals, locals);
            py::print(py::str_("Data directly passed:"), tuple);
        end
        py::finalize_interpreter();
    end

endmodule