import pystim_pkg::*;

module numpy_matrix();
    typedef pystim_pkg::pystim py;

    initial begin
        py_stim_configuration cfg = new();
        cfg.enable_exception_printing();
        py::initialize_interpreter(cfg);
        begin
            automatic py_module np = py_module::import_("numpy");
            automatic py_tuple vecA = py::tuple_({py::int_(1), py::int_(2), py::int_(3)});
            automatic py_tuple vecB = py::tuple_({py::int_(4), py::int_(5), py::int_(6)});

            // Multiply element-wise: C = A * B
            automatic py_object result = np.attr("multiply").call(vecA, vecB);

            // Convert the numpy array result to a Python list
            automatic py_list result_list = result.attr("tolist").call().cast_list();
            
            for(int i = 0; i < result_list.size(); i++) begin
                $display("Result[%0d]: %0d", i, result_list.get(i).cast_int().get_value());
            end
        end
        py::finalize_interpreter();
    end

endmodule